; Macros and Modules Made Simple
;
; Copyright (C) 1993 Alan Bawden

(module extensions
  ;; This module defines the non-standard features that are used by
  ;; `modules.scm'.  Some things here would need to be changed to port this
  ;; system to another Scheme implementation.  This version is specific to
  ;; MIT Scheme.

  ;; Import all the standard R4RS names:

  (use scheme)

  ;; We also need the `primitive-keywords' module so that we can use the
  ;; primitive keywords `define-alias' and `primitive-access':

  (use primitive-keywords)

  (export error eval file-exists? string->uninterned-symbol
	  user-initial-environment)
  (export define-structure unless when)

  ) ; end of (module extensions ...)

; Five variables supplied by MIT Scheme happen to be precisely what we
; need, so we just access them in the underlying implementation:

(define-alias error
  ;; (error <message> <object> ...)
  (primitive-access error))

(define-alias eval
  ;; (eval <form> <environment>)
  (primitive-access eval))

(define-alias file-exists?
  ;; (file-exists? <pathname>)
  (primitive-access file-exists?))

(define-alias string->uninterned-symbol
  ;; (string->uninterned-symbol <string>)
  (primitive-access string->uninterned-symbol))

(define-alias user-initial-environment
  ;; `user-initial-environment' is the environment that `load' uses.
  (primitive-access user-initial-environment))

; Define three non-standard keywords used by `modules.scm' -- these
; definitions would be unchanged if the system was ported elsewhere:

(defmacro (when test . body) (if begin)
  `(,=if ,test
	 (,=begin ,@body)))

(defmacro (unless test . body) (if begin not)
  `(,=if (,=not ,test)
	 (,=begin ,@body)))

; This simple `define-structure' -could- define procedures, but I thought
; it would be more interesting to write it as a macro defining macro.
; This has the problem that it constructs symbols at macroexpand time, so
; it isn't suitable for other macros to expand into a `define-structure'.

(defmacro (define-structure name . slots)
    (begin defmacro vector quote vector-ref vector-set!)
  (define (concat . syms)
    (string->symbol (apply string-append (map symbol->string syms))))
  `(,=begin
     (,=defmacro (,(concat 'make- name) ,@slots) ()
       ;; ",@(list ,@slots)" could be written ",,@slots" in a more
       ;; sophisticated quasiquote implementation:
       `(,',=vector (,',=quote ,',name) ,@(list ,@slots)))
     ,@(let loop ((i 1)
		  (slots slots))
	 (if (null? slots)
	     `()
	     `((,=defmacro (,(concat name '- (car slots)) x) ()
		 `(,',=vector-ref ,x ,',i))
	       (,=defmacro (,(concat 'set- name '- (car slots) '!) x v) ()
		 `(,',=vector-set! ,x ,',i ,v))
	       ,@(loop (+ i 1) (cdr slots)))))))

; Local Variables:
; mode: Scheme
; End:
