from enum import StrEnum


# Minimal action space optimized for the curriculum
# Only includes actions that are actually used
class Action(StrEnum):
    EXACT_HP = "exact hp"
    EXACT_HQ = "exact hq"
    EXACT_HR = "exact hr"

    APPLY_HPQ = "apply hpq"
    APPLY_HQP = "apply hqp"
    APPLY_HPR = "apply hpr"
    APPLY_HRP = "apply hrp"
    APPLY_HQR = "apply hqr"
    APPLY_HRQ = "apply hrq"

    DESTRUCT_HPQ_WITH_HP_HQ = "destruct hpq with hp hq"
    DESTRUCT_HQP_WITH_HQ_HP = "destruct hqp with hq hp"
    DESTRUCT_HPR_WITH_HP_HR = "destruct hpr with hp hr"
    DESTRUCT_HRP_WITH_HR_HP = "destruct hrp with hr hp"
    DESTRUCT_HQR_WITH_HQ_HR = "destruct hqr with hq hr"
    DESTRUCT_HRQ_WITH_HR_HQ = "destruct hrq with hr hq"

    # Structural tactics
    SPLIT = "split"
    LEFT = "left"
    RIGHT = "right"


ACTION_SPACE = list(Action)

