"""The main RL environment and proof script runner."""

from env.state import ProofState
from env.actions import Action
from env import tactics

type Trajectory = list[tuple[ProofState, Action]]


def step(current_state: ProofState, action: Action) -> ProofState | None:
    """
    Applies an action (tactic) to the current state to yield a new state.
    """
    parts = action.split()
    tactic_name = parts[0]
    args = parts[1:]

    if tactic_name == "intros":
        new_state = tactics.tactic_intros(current_state, args)
    elif tactic_name == "exact" and len(args) == 1:
        new_state = tactics.tactic_exact(current_state, args[0])
    elif tactic_name == "split":
        new_state = tactics.tactic_split(current_state)
    elif tactic_name == "destruct" and len(args) == 4 and args[1] == "with":
        new_state = tactics.tactic_destruct(current_state, args[0], [args[2], args[3]])
    elif tactic_name == "apply" and len(args) == 1:
        new_state = tactics.tactic_apply(current_state, args[0])
    elif tactic_name == "left":
        new_state = tactics.tactic_left(current_state)
    elif tactic_name == "right":
        new_state = tactics.tactic_right(current_state)
    elif tactic_name == "cases" and len(args) == 1:
        new_state = tactics.tactic_cases(current_state, args[0])
    else:
        new_state = None

    return new_state
