# put your *.c source files here, make should handle the rest!
SRCS = main.c system_stm32f3xx.c usbd_conf.c stm32f3xx_hal_msp.c	\
logger.c usbd_desc.c stm32f3xx_it.c usbd_cdc_if.c usb_device.c		\
tick_handler.c

# all the files will be generated with this name (main.elf, main.bin, main.hex, etc)
PROJ_NAME=main

# Location of the Libraries folder from the STM32F0xx Standard Peripheral Library
STD_PERIPH_LIB=Drivers

# Location of the linker scripts
LDSCRIPT_INC=Device/ldscripts

# location of OpenOCD Board .cfg files (only used with 'make program')
OPENOCD_BOARD_DIR=/usr/share/openocd/scripts/board

# Configuration (cfg) file containing programming directives for OpenOCD
OPENOCD_PROC_FILE=extra/stm32f3-openocd.cfg

# that's it, no need to change anything below this line!

###################################################

CC=arm-none-eabi-gcc
GDB=arm-none-eabi-gdb
OBJCOPY=arm-none-eabi-objcopy
OBJDUMP=arm-none-eabi-objdump
SIZE=arm-none-eabi-size

CFLAGS  = -Wall -g -std=c99 -Os
CFLAGS += -mlittle-endian -mcpu=cortex-m4  -march=armv7e-m -mthumb
CFLAGS += -mfpu=fpv4-sp-d16 -mfloat-abi=hard
CFLAGS += -ffunction-sections -fdata-sections
CFLAGS += -I Middlewares/ST/STM32_USB_Device_Library/Core/Inc
CFLAGS += -I Middlewares/ST/STM32_USB_Device_Library/Class/CDC/Inc

LDFLAGS += -Wl,--gc-sections -Wl,-Map=$(PROJ_NAME).map --specs=nosys.specs

###################################################

vpath %.a $(STD_PERIPH_LIB) Middlewares/ST/STM32_USB_Device_Library/Class/CDC Middlewares/ST/STM32_USB_Device_Library/Core

ROOT=$(shell pwd)

CFLAGS += -I Inc -DSTM32F303xC
CFLAGS += -I $(STD_PERIPH_LIB)/CMSIS/Device/ST/STM32F3xx/Include
CFLAGS += -I $(STD_PERIPH_LIB)/CMSIS/Include
CFLAGS += -I $(STD_PERIPH_LIB)/STM32F3xx_HAL_Driver/Inc

STARTUP = Device/startup_stm32f303xc.s # add startup file to build

# need if you want to build with -DUSE_CMSIS
#SRCS += stm32f0_discovery.c
#SRCS += stm32f0_discovery.c stm32f0xx_it.c

OBJS = $(addprefix objs/,$(SRCS:.c=.o))
DEPS = $(addprefix deps/,$(SRCS:.c=.d))

###################################################

.PHONY: all lib proj program debug clean reallyclean

all: lib proj

-include $(DEPS)

lib:
	$(MAKE) -C $(STD_PERIPH_LIB)
	$(MAKE) -C Middlewares

proj:	$(PROJ_NAME).elf

dirs:
	mkdir -p deps objs
	touch dirs

objs/%.o : Src/%.c dirs
	$(CC) $(CFLAGS) -c -o $@ $< -MMD -MF deps/$(*F).d

$(PROJ_NAME).elf: $(OBJS)
	$(CC) $(CFLAGS) $(LDFLAGS) $^ -o $@ $(STARTUP) -L$(STD_PERIPH_LIB) -LMiddlewares -lstm32f3 -lstm32usb -L$(LDSCRIPT_INC) -Tstm32f3.ld
	$(OBJCOPY) -O ihex $(PROJ_NAME).elf $(PROJ_NAME).hex
	$(OBJCOPY) -O binary $(PROJ_NAME).elf $(PROJ_NAME).bin
	$(OBJDUMP) -St $(PROJ_NAME).elf >$(PROJ_NAME).lst
	$(SIZE) $(PROJ_NAME).elf

program: all
	openocd -f $(OPENOCD_BOARD_DIR)/stm32f3discovery.cfg -f $(OPENOCD_PROC_FILE) -c "stm_flash `pwd`/$(PROJ_NAME).bin" -c shutdown

debug: program
	$(GDB) -x extra/gdb_cmds $(PROJ_NAME).elf

Firmware.zip: Firmware.Makefile Src/*.c Src/ChangeLog
	-rm -rf /tmp/convect
	mkdir /tmp/convect
	cp -r Firmware.Makefile Convect.pdf Convect.ioc Convect.txt Device Drivers extra Inc Middlewares Src /tmp/convect
	cd /tmp/convect; make clean -f Firmware.Makefile
	cd /tmp; zip Firmware.zip -r convect -x "*~" -x '*SAVE*'
	-mv -f /tmp/Firmware.zip ./
	rm -rf /tmp/convect

TAGS:	$(addprefix Src/,$(SRCS)) Inc/*.h $(STARTUP) Makefile
	etags *.scm $(addprefix Src/,$(SRCS)) Inc/*.h $(STARTUP) Makefile
tags:
	make TAGS
	$(MAKE) -C $(STD_PERIPH_LIB) TAGS
	$(MAKE) -C Middlewares TAGS

clean:
#	find ./ -name '*~' | xargs rm -f
	rm -f objs/*.o
	rm -f deps/*.d
	rm -f dirs TAGS
	rm -f $(PROJ_NAME).elf
	rm -f $(PROJ_NAME).hex
	rm -f $(PROJ_NAME).bin
	rm -f $(PROJ_NAME).map
	rm -f $(PROJ_NAME).lst
	cd Drivers; make clean
	cd Middlewares; make clean

reallyclean: clean
	$(MAKE) -C $(STD_PERIPH_LIB) clean
	$(MAKE) -C Middlewares clean
