
#include "stm32f3xx_hal.h"

const unsigned char segs[16] =
  {
    0x7E, 0x30, 0x6D, 0x79, 0x33, 0x5B, 0x5F, 0x70,
    0x7F, 0x7B, 0x77, 0x1F, 0x4E, 0x3D, 0x4F, 0x47
  };
uint32_t ticnt = 0, /* plcnt = 0, */ switches = 0;
static uint32_t disp_value = 0, hexes = 0;
static unsigned int blade_cnt = 0, blade_rem = 0, last_blade_rem = 0,
  cnt_blades = 0, saw_blades = 0, harm = 1, umph = 1184;
static unsigned long taper = 12, tucnt = 0;
uint16_t fan_cnt = 0, fan_per = 0, fan_rpm = 0, goalrpm = 0;
static long pacc = 0, bldtim = 0, hidx = 0, cntrl = 1024, corpm = 0, tarate = 0;
long tarpm = 0;

extern COMP_HandleTypeDef hcomp5;
extern COMP_HandleTypeDef hcomp4;
extern int capture_mode;
extern int reached_temp;
extern int finished;

uint32_t bcdize(uint32_t bn, int dcnt) {
  if (0==dcnt) return bn;
  return 16 * bcdize(bn / 10, dcnt - 1) + (bn % 10);
}
uint32_t dcbize(uint32_t bcd, int dcnt) {
  if (0==dcnt) return bcd;
  return 10 * dcbize(bcd >> 4, dcnt - 1) + (bcd & 0xF);
}
uint32_t roundquotient(uint32_t num, uint32_t den) {
  uint32_t rem = num % den;
  uint32_t quo = num / den;
  if ((1 & quo) ? (2*rem >= den) : (2*rem > den))
    return quo + 1;
  return quo;
}
#define quotient(x,y) (x/y)
long round_quotient(long num, long den) {
  if (num < 0) return -roundquotient(-num,den);
  else return roundquotient(num,den);
}

void set_tarpm(long target) {
  tarpm = target;
  /* 30 < tarpm <= 105; novel harmonic locking */
#define SCL 4096
  if (tarpm < 54 && (0 == HAL_GPIO_ReadPin(GPIOB, GPIO_PIN_2))) /* vertical */
    /* 3rd harmonic extends vertical wind-tunnel range down to 42.r/min */
    { harm = 3; taper = round_quotient((SCL*(2*umph+tarpm)*harm), (3*tarpm)); }
  else if (tarpm <= 105)
    { harm = 2; taper = round_quotient((SCL*(2*umph+tarpm)*harm), (2*tarpm)); }
  else
    { harm = 2; taper = round_quotient((SCL*(4*1200+tarpm)*harm), (4*tarpm)); }
  /* the harm and taper coefficients were determined by experiment */
  /* they probably need to change for the vertical tunnel configuration */

  /* 300 < tarpm; compressed rpm for gain scaling */
#define BIGL 16777215L
  corpm = BIGL/(BIGL/tarpm+BIGL/3500L);
}

/* phase-lock the fan */
void line_120_callback(void) {
  if (tarpm < 30) {
    GPIOF->BSRRH = GPIO_PIN_6; /* switch fan off */
    bldtim = 0;
  }

  else if (tarpm <= 210) {
    /* harmonic period-locked loop quantized at 105 Hz */
    unsigned int seen_blades = saw_blades;
    saw_blades = 0;
    bldtim += SCL;
    if (0 != seen_blades) {
      if (bldtim >= taper) {	/* blade on time */
	bldtim = 0; hidx = 0;
	GPIOF->BSRRL = GPIO_PIN_6; /* switch fan on */
      } else {		     /* blade is early */
	bldtim = 0; hidx = 0;
	GPIOF->BSRRH = GPIO_PIN_6; /* switch fan off */
      }
    } else			/* no blade */
      if (bldtim >= taper) { 	/* blade is late */
	bldtim = 0; hidx = 0;
	GPIOF->BSRRL = GPIO_PIN_6; /* switch fan on */
      } else if (harm > 1 && ((bldtim+SCL)*harm) >= taper*(hidx+1)) { /* time to pulse */
	GPIOF->BSRRL = GPIO_PIN_6; /* switch fan on */
	hidx = (1+hidx) % harm;
      } else GPIOF->BSRRH = GPIO_PIN_6; /* switch fan off */
  }
#define SBINC (1200*2)
  else {
    /* sawtooth implementation with feed-forward */
    /* This section operates at 120 Hz */
    unsigned int seen_blades = saw_blades;
    saw_blades = 0;
    pacc -= (SBINC)*seen_blades;
    pacc += tarpm;
#define SAWPER 16
#define SAMPLR 16
    tucnt = (tucnt+1) % (SAMPLR*SAWPER);
    if (0==tucnt % (SAMPLR)) {
      /* update cntrl [0:4095] from phase accumulator */
      cntrl += ((pacc*10)/corpm);	/* feedback */
      if (cntrl > 4095) cntrl = 4095;
      if (cntrl < 0) cntrl = 0;
      tarate = cntrl+((pacc*82)/corpm); /* feed-forward */
      if (tarate > 4095) tarate = 4095;
      if (tarate < 0) tarate = 0;
      pacc = 0;
    }
    if ((SAWPER*tarate) / 4096 > (tucnt % (SAWPER)))
      GPIOF->BSRRL = GPIO_PIN_6;     /* switch fan on */
    else GPIOF->BSRRH = GPIO_PIN_6; /* switch fan off */
  }
}

/* Replaces handler in STM32F3xx_HAL_Driver/Src/stm32f3xx_hal_cortex.c */
void HAL_SYSTICK_Callback(void) {
  ticnt = (ticnt + 1) % TICSPERS;

  /* simulate 120 Hz interrupt */
  /* plcnt = (plcnt + 1) % (TICSPERS*66 - 1); /\* was *66 - 1 *\/ */
  /* if (3==plcnt % 10) line_120_callback(); */

  if (0 != cnt_blades) {
    blade_cnt += cnt_blades;
    cnt_blades = 0;
    blade_rem = 0;
  } else blade_rem++;

  /* Display fan rpm on 7-segment display */
  unsigned int digcnt = ((ticnt + 2) / 5) & 0x3;
  if (((ticnt + 2) % 5) == 4) {
    GPIOD->BSRRH = 0xFF;	       /* anodes off */
    /* read switches next tic */
  }
  if (((ticnt + 2) % 5) == 0) {
    unsigned int prdig = (digcnt - 1) & 0x3;
    hexes = (hexes & ~(0xF << (prdig << 2)))
      | (((~GPIOC->IDR >> 10) & 0xF) << (prdig << 2));
    switches = dcbize(hexes, 4);
    GPIOC->BSRRL = 0xF << 6;		/* cathodes off */
    if (capture_mode == 0) {
      unsigned int disp_dig = (disp_value >> (digcnt << 2)) & 0xF;
      GPIOD->BSRRL = segs[disp_dig] << 1;	/* selected anodes on */
    }
    GPIOC->BSRRH = 1 << (6 + digcnt);	/* selected cathode on */
  }
  /* capture_mode = -2; download saved readings -> USB */
  /* capture_mode = -1; stream readings -> USB */
  /* capture_mode = 0; idle */
  /* capture_mode = 1; readings -> flash */
  /* capture_mode = 2; erase flash or initialization */
  if (0 == ticnt) {

    /* Measure speed every second */
    if (2 != capture_mode) {
      /* fan_per and fan_cnt are telemetry */
      fan_per = last_blade_rem + TICSPERS - blade_rem;
      fan_cnt = blade_cnt; blade_cnt = 0;
      last_blade_rem = blade_rem; blade_rem = 0;
      fan_rpm = (0==fan_cnt) ? 0 : round_quotient((20*TICSPERS)*fan_cnt, fan_per);
      disp_value = bcdize(fan_rpm, 4);
    }

    /* vertical: 1164; horizontal: 1184 */
    /* (GPIOB->IDR) & GPIO_PIN_2 */
    umph = (0 == HAL_GPIO_ReadPin(GPIOB, GPIO_PIN_2)) ? 1164 : 1184;
    if (2==capture_mode) {
      /* fan_per = 0; fan_cnt = 0; */
      /* blade_rem = 0; last_blade_rem = 0; */
      pacc = 0;
      set_tarpm(0L);
      GPIOF->BSRRH = GPIO_PIN_6; /* switch fan off */
    } else if ((1 == capture_mode || -1 == capture_mode) && ! reached_temp) {
      if (0 != HAL_GPIO_ReadPin(GPIOB, GPIO_PIN_10)) /* not disk */
	set_tarpm(60L);
      else set_tarpm(0L);
    } else if (finished) set_tarpm(0L);
    else {
      goalrpm = (switches % 1000) + (switches >= 5000 ? 1000L : 0L);
      set_tarpm((goalrpm<105)&&(fan_rpm<goalrpm/2)? 2*goalrpm : goalrpm);
    }
  } /* end of (0 == ticnt) */
}

/* Replaces handler in Drivers/STM32F3xx_HAL_Driver/Src/stm32f3xx_hal_comp.c */
void HAL_COMP_TriggerCallback(COMP_HandleTypeDef *hcomp) {
  /* shaded = HAL_COMP_GetOutputLevel(&hcomp4); */
  if (COMP4 == hcomp->Instance) {
    cnt_blades += 1;
    saw_blades += 1;
  } else if (COMP5 == hcomp->Instance) {
    line_120_callback();
  }
}
