#!/usr/bin/perl -w

use strict;

if ($#ARGV<1) 
  {
    die "not enough arguments";
  }

my $BASEDIR = $ARGV[0];
my $BASEFILE = $ARGV[1];

open(COM,"<COMMENTS.TXT");
my $txt = "";
while(<COM>)
  {
    $txt .= $_;
  }

open(MSG,"<message-verbose.txt");
my $msg = "";
while(<MSG>)
  {
    $msg .= $_;
  }

open(AMSG,">message-verbose.html");
my $imsg = "";

print AMSG "<HTML><HEAD><TITLE>CosmicOS message</TITLE></HEAD>\n";
print AMSG "<BODY BGCOLOR='#ffffff'><TT>\n";
my $name = 0;
for my $m (split(/\n/,$msg))
  {
    my $s = $m;
    $s =~ s/\&/&amp;/g;
    $s =~ s/\</&lt;/g;
    $s =~ s/\>/&gt;/g;
    my $prefix = "";
    my $postfix = "";
    if ($m =~ /\#  ?[A-Z][A-Z]/)
      {
	if ($s =~ /\# *([A-Z]+) *(.*)/)
	  {
	    my $sect = $1;
	    my $comment = $2;
	    $prefix = "<A NAME='$name'><FONT COLOR=red>";
	    $imsg .= "<A HREF='message-verbose.html#$name'>$name</A> ($sect) $comment<BR>\n";
	    $name = $name+1;
	    $postfix = "</FONT>";
	  }
      }
    print AMSG "$prefix$s$postfix<BR>\n";
  }
print AMSG "</TT></BODY>\n";
print AMSG "</HTML>\n";
close(AMSG);

open(TEMPLATE,"<template.html");
my $plate = "";
while(<TEMPLATE>)
  {
    $plate .= $_;
  }

my $entropy = `cp message-stripped.txt entropy.txt; gzip -q -f entropy.txt; wc -c < entropy.txt.gz; rm -f entropy.txt.gz`;
$entropy = $entropy/1024;
$entropy = int(0.5+$entropy*10)/10;

$plate =~ s/XXX/$txt/g;
$plate =~ s/DDD/$BASEDIR/g;
$plate =~ s/FFF/$BASEFILE/g;
$plate =~ s/III/$imsg/g;
$plate =~ s/EEE/$entropy/g;

print $plate;
